/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
/**
 * @class View.Views.Base.ActivityTimelineBaseView
 * @alias SUGAR.App.view.views.BaseActivityTimelineBaseView
 * @extends View.View
 */
({
	extendsFrom: 'ActivityTimelineBaseView',
	/**
     * Array default modules
     */
    defaultModules: [
        'Calls',
        'Emails',
        'Meetings',
        'Messages',
        'Notes',
        'Tasks',
		'sf_Dialogs',
		'sf_webActivity',
		'sf_EventManagement',
    ],
	initialize: function(options) {
		this._super('initialize', [options]);
		app.api.call('GET', "./sugar_version.json", null, {success: function (data) {
				if((data.sugar_version).includes("-")){
					verison = (data.sugar_version).split("-");
					this.sugarVersion = verison[0];
				}else{
					this.sugarVersion = data.sugar_version;
				}
				sessionStorage.setItem("sugar_version", this.sugarVersion);				
			},error: function (e) { 
				console.log("=======ERROR=======:"+e);
			},
		},{async: false});
    },
	
	/**
     * @inheritdoc
     *
     * Inject the singular module name.
     */
    _render: function() {
		if(parseFloat(sessionStorage.getItem("sugar_version")) <= parseFloat("13.0")){
			console.log("==== <= 13.0 ====");
			this.disposeActivities();
			this._super('_render');
			if (this.models) {
				this.$('.activity-timeline-cards').html('');
				this.appendCardsToView(this.models);
			}
		}else if(parseFloat(sessionStorage.getItem("sugar_version")) <= parseFloat("13.1")){
			console.log("==== <= 13.1 ====");
			this.disposeActivities();
			this._super('_render');
			if (this.models) {
				this.$('.activity-timeline-cards').html('');
				this.appendCardsToView(this.models);
			}
		} else {
			console.log("==== else ====");
			this._super('_render');
			this._renderCards();
		}
    },
	/**
     * Set icon class attributess on related collection models base on module type
     */
    _setIconClass: function() {
		if (this.models) {
            _.each(this.models, function(model) {
                // it's a change card if the model's module is Audit, use this.module
                var mod = model.get('_module') == 'Audit' ? this.module : model.get('_module');
                const moduleMeta = app.metadata.getModule(mod);
                model.set('icon_module', mod);
				
				var cust_iconname = 'sicon-default-module-lg';
				if( model.get('_module')=='sf_webActivity') {
					moduleMeta.icon = 'sicon-web-lg';
				}				
				if( model.get('_module')=='sf_Dialogs') {
					moduleMeta.icon = 'sicon-edit-lg';
				}				
				if( model.get('_module')=='sf_EventManagement') {
					moduleMeta.icon = 'sicon-events-lg';
				}				
                //model.set('icon_class', moduleMeta.icon || 'sicon-default-module-lg'); default code
                model.set('icon_class', moduleMeta.icon || cust_iconname);
            }, this);
        }
    },
	
	/**
     * Appends cards
     * @param models array of models to be added to the view
     */
    appendCardsToView: function(models) {
		var verison="";
		var _self = this;   
		_self._setIconClass();
		_self.inst_version="";
		
		if(parseFloat(sessionStorage.getItem("sugar_version")) <= parseFloat("13.0")){
			//OLD CODE HERE
			console.log("===ACTIVITY-TIMELINE-BASE OLD CODE HERE====");
			_.each(models, _.bind(function(model) {
				_self._patchFieldsToModel(model);
				var layout = _self.createCard(model);
				
				if (layout) {
					
					if( model.get('_module')=='sf_webActivity'  && $(layout.el).find('.panel-body span:nth-child(1)').length > 0) {
						var duration = $(layout.el).find('.panel-body span:nth-child(1) div') ? $(layout.el).find('.panel-body span:nth-child(1) div').attr('title') : '';
						if( duration != "" && duration != undefined) {
							$(layout.el).find('.panel-body span:nth-child(1)').html('<div class="ellipsis_inline" data-placement="bottom" title="" data-original-title="'+duration+'">Duration: '+duration+' Seconds</div>');
							_self.$('.activity-timeline-cards').append(layout.el);
						}else if(duration == undefined) {
							$(layout.el).find('.panel-body span:nth-child(1)').html('<div class="ellipsis_inline" data-placement="bottom" title="" data-original-title="">Duration: </div>');
							_self.$('.activity-timeline-cards').append(layout.el);
						}
						
					}
					
					if( model.get('_module')=='sf_Dialogs'  && $(layout.el).find('.activity-card-content-body .panel-header span:nth-child(1)').length > 0) {
						var completed = $(layout.el).find('.activity-card-content-body .panel-header span:nth-child(1) div') ? $(layout.el).find('.activity-card-content-body .panel-header span:nth-child(1) div').attr('title') : '';
						if( completed != ""  && completed != undefined) {
							$(layout.el).find('.activity-card-content-body .panel-header span:nth-child(1)').html('<div class="ellipsis_inline" data-placement="bottom" title="" data-original-title="'+completed+'">Completed '+completed+'</div>');
							_self.$('.activity-timeline-cards').append(layout.el);
						}
						
					}
					
					if( model.get('_module')=='sf_EventManagement' && $(layout.el).find('.activity-card-content-body .panel-body span:nth-child(1)').length > 0 && $(layout.el).find('.activity-card-content-body .panel-body span:nth-child(2)').length > 0) {
						
						var layoutElChild1Input = $(layout.el).find('.activity-card-content-body .panel-body span:nth-child(2) input');

						if(layoutElChild1Input.length > 0) {
							var register_el_val = layoutElChild1Input.attr('aria-label');
							var is_register = layoutElChild1Input.prop('checked');
						}
						
						var layoutElChild2Input = $(layout.el).find('.activity-card-content-body .panel-body span:nth-child(1) input');
						
						if(layoutElChild2Input.length > 0) {
							var attended_el_val = layoutElChild2Input.attr('aria-label');
							var is_attended = layoutElChild2Input.prop('checked');
						}

						if( (register_el_val=='Registered' && is_register ) && is_register != undefined) {
							$(layout.el).find('.activity-card-content-body .panel-body span:nth-child(1)').html('<span class="label label-info" style="margin-left:10px;">Registered</span>');
							_self.$('.activity-timeline-cards').append(layout.el);
						} else {
							$(layout.el).find('.activity-card-content-body .panel-body span:nth-child(1)').html('');
							_self.$('.activity-timeline-cards').append(layout.el);
						}
						
						if( (attended_el_val=='Attended' && is_attended ) && is_attended != undefined) {
							$(layout.el).find('.activity-card-content-body .panel-body span:nth-child(2)').html('<span class="label label-success" style="margin-bottom: 10px; margin-top: 5px; margin-left:10px;" >Attended</span>');
							_self.$('.activity-timeline-cards').append(layout.el);
						} else {
							$(layout.el).find('.activity-card-content-body .panel-body span:nth-child(2)').html('');
							_self.$('.activity-timeline-cards').append(layout.el);
						}
						
					} else {
						_self.$('.activity-timeline-cards').append(layout.el); //defult code
					}
				}

				// check menu icon visibilities
				layout.setCardMenuVisibilities();
			}, _self));
			
		}else{
			//NEW CODE HERE
			console.log("===ACTIVITY-TIMELINE-BASE NEW CODE HERE====");
			_.each(models, _.bind(function(model) {
				_self._patchFieldsToModel(model);
				var layout = _self.createCard(model);

				if (layout) {
					
					if(model.get('_module')=='sf_webActivity'){
						if($(layout.el).find('.panel-body span:nth-child(2)').length > 0){
							var duration = $(layout.el).find('.panel-body span:nth-child(2) div') ? $(layout.el).find('.panel-body span:nth-child(2) div').attr('title') : ''; 
							if( duration != "" && duration != undefined) {
								$(layout.el).find('.panel-body span:nth-child(2)').html('<div class="ellipsis_inline" data-placement="bottom" title="" data-original-title="'+duration+'">Duration: '+duration+' Seconds</div>');
								_self.$('.activity-timeline-cards').append(layout.el);
							}else if(duration == undefined) {
								$(layout.el).find('.panel-body span:nth-child(2)').html('<div class="ellipsis_inline" data-placement="bottom" title="" data-original-title="">Duration: </div>');
								_self.$('.activity-timeline-cards').append(layout.el);
							}
						}else if($(layout.el).find('.panel-body span:nth-child(1)').length > 0){
							var duration = $(layout.el).find('.panel-body span:nth-child(1) div') ? $(layout.el).find('.panel-body span:nth-child(1) div').attr('title') : ''; 
							if( duration != "" && duration != undefined) {
								$(layout.el).find('.panel-body span:nth-child(1)').html('<div class="ellipsis_inline" data-placement="bottom" title="" data-original-title="'+duration+'">Duration: '+duration+' Seconds</div>');
								_self.$('.activity-timeline-cards').append(layout.el);
							}else if(duration == undefined) {
								$(layout.el).find('.panel-body span:nth-child(1)').html('<div class="ellipsis_inline" data-placement="bottom" title="" data-original-title="">Duration: </div>');
								_self.$('.activity-timeline-cards').append(layout.el);
							}
						}
					}
					
					if( model.get('_module')=='sf_Dialogs'  && $(layout.el).find('.activity-card-content-body .panel-header span:nth-child(2)').length > 0) {
						var completed = $(layout.el).find('.activity-card-content-body .panel-header span:nth-child(2) div') ? $(layout.el).find('.activity-card-content-body .panel-header span:nth-child(2) div').attr('title') : '';
						if( completed != ""  && completed != undefined) {
							$(layout.el).find('.activity-card-content-body .panel-header span:nth-child(2)').html('<div class="ellipsis_inline" data-placement="bottom" title="" data-original-title="'+completed+'">Completed '+completed+'</div>');
							_self.$('.activity-timeline-cards').append(layout.el);
						}
					}				
					
					if( model.get('_module')=='sf_EventManagement' && $(layout.el).find('.activity-card-content-body .panel-body span').length > 0 ) {
						var layoutElChild1Input = $(layout.el).find('.activity-card-content-body .panel-body span:nth-child(1) input');
						
						if(layoutElChild1Input.length > 0) {
							var attended_el_val = layoutElChild1Input.attr('aria-label');//Attended
							var is_attended = layoutElChild1Input.prop('checked'); 
						}
						
						var layoutElChild2Input = $(layout.el).find('.activity-card-content-body .panel-body span:nth-child(2) input');
						
						if(layoutElChild2Input.length > 0) {
							var register_el_val = layoutElChild2Input.attr('aria-label');//Registered 
							var is_register = layoutElChild2Input.prop('checked');  
						}

						if( register_el_val=='Registered' && is_register && is_register != undefined) {
							$(layout.el).find('.activity-card-content-body .panel-body span:nth-child(1)').html('<span class="label label-info" style="margin-left:10px;">Registered</span>');
							_self.$('.activity-timeline-cards').append(layout.el);
						} else {
							$(layout.el).find('.activity-card-content-body .panel-body span:nth-child(1)').html('');
							_self.$('.activity-timeline-cards').append(layout.el);
						}						
						if( attended_el_val=='Attended' && is_attended && is_attended != undefined) {
							$(layout.el).find('.activity-card-content-body .panel-body span:nth-child(2)').html('<span class="label label-success" style="margin-bottom: 10px; margin-top: 5px; margin-left:10px;" >Attended</span>');
							_self.$('.activity-timeline-cards').append(layout.el);
						} else {
							$(layout.el).find('.activity-card-content-body .panel-body span:nth-child(2)').html('');
							_self.$('.activity-timeline-cards').append(layout.el);
						}						
					} else {
						_self.$('.activity-timeline-cards').append(layout.el);//defult code
					}
				}   
				
				// check menu icon visibilities
				layout.setCardMenuVisibilities();
			}, _self));
		}
    },
})
