/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
/**
 * @class View.Views.Base.ActivityTimelineView
 * @alias SUGAR.App.view.views.BaseActivityTimelineView
 * @extends View.Views.Base.ActivityTimelineBaseView
 */
({
    extendsFrom: 'ActivityTimelineView',
	/**
     * Array default modules
     */
    defaultModulesSf: [
		'sf_Dialogs',
		'sf_webActivity',
		'sf_EventManagement'
    ],

    /**
     * Default mapping of module to link name
     */
    moduleLinkMappingSf: {	
		sf_Dialogs: 'sf_dialogs_contacts',
		sf_webActivity: 'sf_webactivity_contacts',
		sf_EventManagement: 'sf_eventmanagement_contacts',
		sf_webActivity: 'sf_webactivity_accounts',
		sf_Dialogs: 'sf_dialogs_leads',
		sf_webActivity: 'sf_webactivity_leads',
		sf_EventManagement: 'sf_eventmanagement_leads'
    },
	
	/**
     * Boolean status of whether we should override the handleFilter method or not
     */
    shouldOverrideHandleFilter: false,
	
	initialize: function(options) {
		this._super('initialize', [options]);
		
		this.moduleIcons = {...this.moduleIcons, ...this.moduleIconsSf};		
        if (this.moduleLinkMapping) {
            this.shouldOverrideHandleFilter = true;
            this.defaultModules = [...this.defaultModules, ...this.defaultModulesSf];
            this.moduleLinkMapping = {...this.moduleLinkMapping, ...this.moduleLinkMappingSf};
        }
		app.api.call('GET', "./sugar_version.json", null, {success: function (data) {
				if((data.sugar_version).includes("-")){
					verison = (data.sugar_version).split("-");
					this.sugarVersion = verison[0];
				}else{
					this.sugarVersion = data.sugar_version;
				}
				sessionStorage.setItem("sugar_version", this.sugarVersion);				
			},error: function (e) {
				console.log("=======ERROR=======:"+e);
			},
		},{async: false});
    },
	
	/**
     * Handle of filter change event
     *
     * @param {string} filterModule name of filtered module
     * @param {boolean} silent
     */
    handleFilter: function(filterModule, silent) {
		var _self = this;
		_self.inst_version="";
		var verison="";
		if (!silent || !_self.filter.module) {
			if(parseFloat(sessionStorage.getItem("sugar_version")) <= parseFloat("13.0")){
				//OLD CODE HERE
				console.log("===ACTIVITY-TIMELINE OLD CODE HERE====");
				if (!_self.shouldOverrideHandleFilter) {
					_self._super('handleFilter', [filterModule, silent]);
					return;
				}				
				var selectedModule = filterModule;
				if (selectedModule !== 'all_modules') {
					selectedModule = _.findKey(_self.moduleLinkMapping, function(item) {
						return item === selectedModule;
					});
				}
				var isModuleAvailable = app.metadata.getModule(selectedModule);
				if (filterModule == 'sf_dialogs') {
					_self.filter.module = 'sf_Dialogs';
				} else if (filterModule == 'sf_webactivity') {
					_self.filter.module = 'sf_webActivity';
				} else if (filterModule == 'sf_eventmanagement') {
					_self.filter.module = 'sf_EventManagement';
				} else {
					_self.filter.module = isModuleAvailable ? selectedModule : 'all_modules';
				}
				_self._setActivityModulesAndFields(_self.baseModule);
				_self.reloadData();
			}else{
				//NEW CODE HERE
				console.log("===ACTIVITY-TIMELINE NEW CODE HERE====");
				var cust_relatedModule = "";
				if (filterModule == 'sf_dialogs') {
					filterModule = 'sf_Dialogs';
				} 
				if (filterModule == 'sf_webactivity') {
					
					filterModule = 'sf_webActivity';
				} 
				if (filterModule == 'sf_eventmanagement') {
					filterModule = 'sf_EventManagement';
				}
				
				const relatedModule = filterModule === 'audit' ? 'Audit' :
					app.data.getRelatedModule(_self.baseModule, filterModule);
				const isModuleAvailable = filterModule === 'audit' ? true :
					app.metadata.getModule(relatedModule);
				
				if(relatedModule && relatedModule != undefined){
					_self.filter.module = isModuleAvailable ? relatedModule : 'all_modules';
				}else{
					_self.filter.module = filterModule;  
				}
				_self._setActivityModulesAndFields(_self.baseModule);
				_self._initCollection();
				_self.reloadData();
			}
		}
    },	
})
